% Code will require manipulation prior to running

clear all;
close all;
clc;

addpath('F:\Wave_processing')

%% Path of the wave logger data
pathFiles = {'F:\Wave_processing\Final\OSSI_Deployment_5\'};

%% Set-up parameters
fs      = 5;               % instrument sampling frequency [Hz]
nr_days = 5;               % number of days
spd     = 86400;            % number of seconds per day, *172800

% %% Time vector
tt = 0:1/fs:nr_days*spd;     % time vector

%% Reading pressure data

Path1    = 'F:\Wave_processing\Final\OSSI_Deployment_5\';
Path_figures= 'F:\Wave_processing\Final\OSSI_Deployment_5\Figures_final\';
Folder   = {'001\';'002\';'003\';'004\';'005\';'006\'};


for OSSI = [1 2 3 4 5 6] % Malfunction of OSSI 005 during Deployment 1
    %% Loading structure file of the OSSI  
    
    folder    = Folder{OSSI};
    Path      = {strcat(Path1,folder)};
    Indx=[];
    Tm02=[];
    load('matlab_recorded_WL_Time_Georgetown_station.mat','WL_m_5dp','datetime_5dp');
       
    for i_loc = 1:length(Path)   % loop over pressure sensor locations

        p = NaN(length(tt),1);         % pressure vector   
        t = NaN(length(tt),1);         % time vector
        
        if OSSI==1
            elev = [0.06]; % set the elevation of the ADV above the bed
        elseif OSSI==2
            elev = [0.06];
        elseif OSSI==3
            elev = [0.06];
        elseif OSSI==4
            elev = [0.06];
        elseif OSSI==5
            elev = [0.06];
        else
            elev =[0.06];
        end
            
        WL_DATA=rawOSSI2struct([char(Path) '\']);
        rawdata=strcat(strcat('WL_DATA_00',num2str(OSSI),'.mat'));
        save(rawdata,'WL_DATA')
        
        d= (WL_DATA.rawdata)';
        
        %Checking data fro NAN
        if sum(isnan(d))~=0;
            %error('Input file contains NaN value(s), Oceanlyz will be terminated.');
            warning('Input file contains NaN value(s).');
            warning('NaN value(s) are replaced by linearly interpolated value(s).');
            warning('Oceanlyz contniues with modified data.');
            
            %Replacing NaN values
            Indx(:,1)=linspace(1,length(d(:,1)),length(d(:,1)));
            d=interp1(Indx(isnan(d)==0),d(isnan(d)==0),Indx);
        end
        
        %Checking data for Inf
        if sum(isinf(d))~=0
            %error('Input file contains Inf value(s), Oceanlyz will be terminated.');
            warning('Input file contains Inf value(s).');
            warning('Inf value(s) are replaced by linearly interpolated value(s).');
            warning('Oceanlyz contniues with modified data.');
    
            %Replacing Inf values
            Indx(:,1)=linspace(1,length(d(:,1)),length(d(:,1)));
            d=interp1(Indx(isinf(d)==0),d(isinf(d)==0),Indx);
        end

        %Checking data for zero values
        if sum(d==0)~=0
            warning('Input file contains Zero value(s), Oceanlyz contniues with current data.');
        end

        % Remove unacceptable data
        
        %full series: Deployment #- set to 
        i0= 1+10*60*60*5;
        ie= i0+4*(24*60*60*5);
        nb= (ie-i0)/(30*60*5); %number of bursts (15/ 30 mins)
        
        d= d';
        d=d(i0:ie);
        t=WL_DATA.datetime(i0:ie);
        
        p=d.*(1/0.0980665); % conversion from bar to mH20
               
        d_trial=d';
        save(strcat('d_trial.mat'),'d_trial');
        
        %%  %Specific Dates 
        WL_DATA_selection.datetime          =WL_DATA.datetime(i0:ie);
        WL_DATA_selection.rawdata           =WL_DATA.rawdata(i0:ie);
        WL_DATA_selection.pressuredata      =WL_DATA.pressuredata(i0:ie);
        
        %save date selection
        date_data=strcat(strcat('WL_DATA_selection_00',num2str(OSSI),'.mat'));
        save(date_data,'WL_DATA_selection')
        
    %% Air pressure correction- not needed OSSI is a Guage Transducer- data= total pressure-atmospheric pressure
    p_apcor=p;
    
    % Filtering waves- removing the dy
    p_tide = movmean(p_apcor,6001,'omitnan'); % moving mean to filter out waves and look at tide+surge, why 6001-sample 20mins

    eval(['p' num2str(i_loc) '=p;']);
    eval(['p' num2str(i_loc) '_apcor=p_apcor;']);
    eval(['p' num2str(i_loc) '_tide_apcor=p_tide;']);
    
    end

%% Spectral Analysis

nt   = length(p);    % total duration of the pressure signals
du   = 1200;          % duration of the intervals where wave parameters are calculated (s) (30 mins =1800s)
dt   = 1/fs;          % time interval between pressure measurements (s)
nh   = round(du/dt);  % number of measurements in a du (s) long interval
np   = floor(nt/nh);  % total number of measurements in the pressure signals

nsample = 2^7*fs;    % 
df = 1/nsample/dt;    % frequency resolution


t_sec=(datenum(t-t(1)).*24*3600)';  %Time in seconds
P_test=p;

 for jp =1:1:np
     

    np-jp;             % remaining intervals for analysis
    tm(jp)=jp;  
    % Edit this to plot a select number of bursts
    
    %% Selecting pressure data of interval jp
    Pt1       = P_test(1+(jp-1)*nh:jp*nh); % selecting pressure
    t_burst   = t(1+(jp-1)*nh:jp*nh); %selecting time
    
    Pm1(jp)   = mean(Pt1);                           % mean pressure (mH20)- Separation of the Hydrostatic Pressure
    Pss1      = detrend(Pt1);                        % wave pressure (mH20)- Separation of the Dynamic Pressure
    h1(jp)    = elev+ Pm1(jp);                       % depth (mH20)
    var_p(jp,1) = var(Pss1(:));
    %% Variance Density Spectrum
     
     pp=P_test(1+(jp-1)*nh:jp*nh);
     tt=t_sec(1+(jp-1)*nh:jp*nh);
     
   % if var_p(jp,1)>=0.00001;
     
     %Producing the Variance Density Plot per burst
     [f,v]= spectrumsimple(tt(:), pp(:),'detrend',1);
     Spectral_Calculation.f=f;
     Spectral_Calculation.v=v;
     
     savefig(gcf, [Path_figures,'Variance_Density' '_' num2str(OSSI) '_' num2str(jp) '.fig'], 'compact')
     saveas(gcf,  [Path_figures,'Variance_Density' '_' num2str(OSSI) '_' num2str(jp) '.png'])
     close(gcf);
     %Separation of the Infragravity Waves from the Swell
     
     %Energy Density Spectrum
     rho= 1026; %kg/m3
     g=9.81; %m/s2
     E_spec= rho*g*v;
     
   %  Spectral_Calculation.E=E_spec;
     
     %save variance selection
     variance_data=strcat(strcat('Spectral_Calculation_00',num2str(OSSI),'_', num2str(jp), '.mat'));
     save(variance_data,'Spectral_Calculation')
     
     %%
     %save variance selection
     variance_data=strcat(strcat('Spectral_Calculation_00',num2str(OSSI),'.mat'));
     save(variance_data,'Spectral_Calculation')

     pp3 = detrend(pp(1:nh),1); % Dynamic Pressure
     % Infragravity Waves 0-0.04Hz and Swell and shat waves 0.04-5Hz
     [ up ] = bpass(pp3(:),dt,0,0.04 );
     [ up2 ] = bpass(pp3(:),dt,0.04,5 );
     
      tt_end(jp,1)=t(1);
     
     figure2 = figure;
     figure2.WindowState = 'maximized';

     axes2 = axes('Parent',figure2);
     hold(axes2,'on');
     plot(tt,up2,'LineWidth',2); 
     hold on; 
     plot(tt,up,'LineWidth',2);
     title(' Waves Heights IG and SW ');
     xlabel('Time (MM DD HH MM SS','FontWeight','bold','FontAngle','italic');
     ylabel('Height (mH2O)','FontWeight','bold','FontAngle','italic');
     box(axes2,'on');
     set(axes2,'FontAngle','italic','FontSize',20,'XGrid','on','XMinorTick','on',...
     'YGrid','on');
 
     savefig(gcf, [Path_figures,'Swell & IG Waves per Burst' '_' num2str(OSSI) '_' num2str(jp) '.fig'], 'compact')
     saveas(gcf,  [Path_figures,'Swell & IG Waves per Burst' '_' num2str(OSSI) '_' num2str(jp) '.png'])
 
 
     delete(figure2)
    %% Calculating pressure spectrum
   [Ps1,F1]  = jspect(Pss1,Pss1,nsample,dt,1,1,1);
   
   %[P,F] = spectrum(Pss1,fs);   % gives spectrum from 0 to Fnyq
    
    if jp == 1
       k1 = zeros(length(F1),1);
       
       for kk = 1:length(k1)
               k1(kk) = wavenumber(1/F1(kk),h1(jp)); % wave number
       end
       
     %% Converting from pressure spectrum to surface elevation spectrum
       
       trans1    = (cosh(k1.*(h1(jp)))./(cosh(k1.*elev))).^2; 
       trans1    = min(trans1,3);
       
     %% Selecting high frequencies and low frequencies  ---Maybe alter this
       
       %ilow1     = find(F1>0 & F1<=0.05);
       %ihigh1    = find(F1>0.05);
       
       ilow1     = find(F1>0.04 & F1<=1);  % Short Wave (1-25 sces)
       ihigh1    = find(F1>0.04);   % Long Wave (f>25 sces)
    
    end
    
   if var_p(jp,1)>=0.001;
    
        Es1(:,jp,1)      = Ps1(:,1).*trans1;                  % surface elevation spectrum
        m0(jp,1)         = sum(Es1(:,jp,1))*df;               % m0
        %Etot(jp,1)       = rho*g*(sum(Es1(:,jp,1))*df);
        Hm01(jp,1)       = 4*sqrt(sum(Es1(:,jp,1))*df);       % significant wave height
        Hmax(jp,1)       =max(Hm01);
        Hm0_hi1(jp,1)    = 4*sqrt(sum(Es1(ihigh1,jp,1))*df);  % significant wave height, of high frequency range
        Hm0_lo1(jp,1)    = 4*sqrt(sum(Es1(ilow1,jp,1))*df);   % significant wave height, of low frequency range
        Tm01(jp,1)       = (sum(Es1(:,jp,1))*df)/(sum(F1.*Es1(:,jp,1)*df)); % mean period
  
    else
        fprintf('Spectral Calculation will not be computed  \n')
    end
    
end

%% Plotting wave properties

%[Tm02 spikes]=spikeRemoval(Tm01);

figure_spec=figure('Color',[1 1 1]);
figure_spec.WindowState = 'maximized';
axes_spec = axes('Parent',figure_spec);

paperDims(1.2,1), holdGridBox

subplot1 = subplot(3,1,1,'Parent',figure_spec);
hold(subplot1,'on');
plot(Hm01,'Parent',subplot1,'MarkerSize',8,'LineWidth',2,'Color',[0 0 0]);
ylabel('H_{s}  [m]','VerticalAlignment','bottom','FontName','calibri');
%xlim(subplot1,[0 200]);
box(subplot1,'on');
set(subplot1,'FontName','calibri','FontSize',20,'LineWidth',0.75,'XGrid',...
    'on','YGrid','on');

% Create subplot
subplot2 = subplot(3,1,2,'Parent',figure_spec);
hold(subplot2,'on');
plot(Tm01,'Parent',subplot2,'MarkerSize',8,'LineWidth',2,'Color',[1 0 0]);
ylabel('T_{m}  [s]','VerticalAlignment','bottom','FontName','calibri');
%xlim(subplot2,[0 200]);
box(subplot2,'on');
set(subplot2,'FontName','calibri','FontSize',20,'LineWidth',0.75,'XGrid',...
    'on','YGrid','on');

% Create subplot
subplot3 = subplot(3,1,3,'Parent',figure_spec);
hold(subplot3,'on');
plot(h1,'Parent',subplot3,'MarkerSize',8,'LineWidth',2,'Color',[0 0 1]);
ylabel('Depth [m]','VerticalAlignment','bottom','FontName','calibri');
xlabel('Burst No. (-)','VerticalAlignment','cap','FontName','calibri');
box(subplot3,'on');
%xlim(subplot3,[0 200]);
box(subplot3,'on');
set(subplot3,'FontName','calibri','FontSize',20,'LineWidth',0.75,'XGrid',...
    'on','YGrid','on');

%datetick('x', 'MM')

savefig(gcf, [Path_figures,'Spectral Analysis' '_' num2str(OSSI) '_' num2str(jp) '.fig'], 'compact')
saveas(gcf,  [Path_figures,'Spectral Analysis' '_' num2str(OSSI) '_' num2str(jp) '.png'])
 
%% Saving variables
Results.Es1=  Es1;
Results.m0= m0;
Results.Hm0 = Hm01;
Results.Hm0hi1 = Hm0_hi1;
Results.Hm0lo1 = Hm0_lo1;
Results.Tm0 = Tm01;
Results.Depth = h1;
Results.pressure = p1;
Results.time = t;
Results.var=var_p; %Check for good bursts
Results.IG=up; %IG
Results.SW=up2;
Results.v=v; %Variance Spec
Results.f=f; %Frequency
%Results.Wave_shear=Wave_shear;
Results.E=E_spec; % Energy Spec


fullname=strcat(strcat(Path1,'WaveParameters_00', num2str(OSSI), '.mat'));
save(fullname,'Results')
end
%% Hm V2
clear all
% Comparison of Wave Heights
load('WaveParameters_001.mat');
hm0_1=Results.Hm0;
H_001(:,1)=Results.Hm0(271,1);
H_001(:,2)=mean(Results.Hm0);
H_001(:,3)=min(Results.Hm0);
clear Results;


load('WaveParameters_002.mat');
hm0_2=Results.Hm0;
H_002(:,1)=Results.Hm0(271,1);
H_002(:,2)=mean(Results.Hm0);
H_002(:,3)=min(Results.Hm0);
clear Results;

load('WaveParameters_003.mat');
hm0_3=Results.Hm0;
H_003(:,1)=Results.Hm0(280,1);
H_003(:,2)=mean(Results.Hm0);
H_003(:,3)=min(Results.Hm0);
clear Results;

load('WaveParameters_004.mat');
hm0_4=Results.Hm0;
H_004(:,1)=Results.Hm0(271,1);
H_004(:,2)=mean(Results.Hm0);
H_004(:,3)=min(Results.Hm0);

clear Results;

load('WaveParameters_005.mat');
hm0_5=Results.Hm0;
H_005(:,1)=Results.Hm0(278,1);
H_005(:,2)=mean(Results.Hm0);
H_005(:,3)=min(Results.Hm0);

clear Results;

load('WaveParameters_006.mat');
hm0_6=Results.Hm0;
H_006(:,1)=Results.Hm0(271,1);
H_006(:,2)=mean(Results.Hm0);
H_006(:,3)=min(Results.Hm0);
clear Results;

H_all(1,:)=H_001(:,1);
H_all(2,:)=H_001(:,2);
H_all(3,:)=H_001(:,3);
H_all(4,:)=H_002(:,1);
H_all(6,:)=H_002(:,2);
H_all(7,:)=H_002(:,3);
H_all(8,:)=H_003(:,1);
H_all(9,:)=H_003(:,2);
H_all(10,:)=H_003(:,3);
H_all(11,:)=H_004(:,1);
H_all(12,:)=H_004(:,2);
H_all(13,:)=H_004(:,3);
H_all(14,:)=H_005(:,1);
H_all(15,:)=H_005(:,2);
H_all(16,:)=H_005(:,3);
H_all(17,:)=H_006(:,1);
H_all(18,:)=H_006(:,2);
H_all(19,:)=H_006(:,3);


figure_Hm=figure;
figure_Hm.WindowState = 'maximized';

axesHm = axes('Parent',figure_Hm);
hold(axesHm,'on');
scatter(1620,H_all(17,:),'LineWidth',2); 
hold on; 
scatter(1020,H_all(4,:),'LineWidth',2); 
hold on; 
scatter(810,H_all(11,:),'LineWidth',2); 
hold on; 
scatter(330,H_all(1,:),'LineWidth',2); 
hold on; 
scatter(100,H_all(14,:),'LineWidth',2); 
hold on; 
scatter(23, H_all(8,:),'LineWidth',2); 
hold on;
%max
x_plot=[1620 1020 810 330 100 23].';
y_plot=[H_all(17,:) H_all(4,:) H_all(11,:) H_all(1,:) H_all(14,:) H_all(8,:)].';
line(x_plot, y_plot,'LineWidth',1,'LineStyle','--');
hold on;
%mean
x_plot=[1620 1020 810 330 100 23].';
y_plot=[H_all(18,:) H_all(6,:) H_all(12,:) H_all(2,:) H_all(15,:) H_all(9,:)].';
line(x_plot, y_plot,'LineWidth',3);
hold on;
%min
x_plot=[1620 1020 810 330 100 23].';
y_plot=[H_all(19,:) H_all(7,:) H_all(13,:) H_all(3,:) H_all(16,:) H_all(10,:)].';
line(x_plot, y_plot,'LineWidth',1,'LineStyle','--');


%title(' Cross-shore Variation');
xlabel('Cross-shore Distance [m]','FontWeight','bold','FontAngle','italic');
ylabel('H_s [m]','FontWeight','bold','FontAngle','italic');
box(axesHm,'on');
set(axesHm,'FontAngle','italic','FontSize',24,'XDir','reverse','XGrid','on','XMinorTick','on',...
'YGrid','on');
legend('MB 8','MB 7','MB 6','MB 4','MB 2','MB 1')

Path_figures= 'F:\Wave_processing\Final\OSSI_Deployment_5\Figures_final\';

savefig(gcf, [Path_figures,'All,  Sig. Wave Heights v2' '.fig'], 'compact')
saveas(gcf,  [Path_figures,'All  Sig. Wave Heights v2' '.png'])

delete(figure_Hm)


%% Hm V3
clear all
% Comparison of Wave Heights
load('WaveParameters_001.mat');
hm0_1=Results.Hm0;
H_001(:,1)=Results.Hm0(271,1);
H_001(:,2)=mean(nonzeros(Results.Hm0));
H_001(:,3)=min(Results.Hm0);
H_001(:,4)=min(nonzeros(Results.Hm0));
clear Results;


load('WaveParameters_002.mat');
hm0_2=Results.Hm0;
H_002(:,1)=Results.Hm0(271,1);
H_002(:,2)=mean(nonzeros(Results.Hm0));
H_002(:,3)=min(Results.Hm0);
H_002(:,4)=min(nonzeros(Results.Hm0));
clear Results;

load('WaveParameters_003.mat');
hm0_3=Results.Hm0;
H_003(:,1)=Results.Hm0(280,1);
H_003(:,2)=mean(nonzeros(Results.Hm0));
H_003(:,3)=min(Results.Hm0);
H_003(:,4)=min(nonzeros(Results.Hm0));
clear Results;

load('WaveParameters_004.mat');
hm0_4=Results.Hm0;
H_004(:,1)=Results.Hm0(271,1);
H_004(:,2)=mean(nonzeros(Results.Hm0));
H_004(:,3)=min(Results.Hm0);
H_004(:,4)=min(nonzeros(Results.Hm0));

clear Results;

load('WaveParameters_005.mat');
hm0_5=Results.Hm0;
H_005(:,1)=Results.Hm0(278,1);
H_005(:,2)=mean(nonzeros(Results.Hm0));
H_005(:,3)=min(Results.Hm0);
H_005(:,4)=min(nonzeros(Results.Hm0));

clear Results;

load('WaveParameters_006.mat');
hm0_6=Results.Hm0;
H_006(:,1)=Results.Hm0(271,1);
H_006(:,2)=mean(nonzeros(Results.Hm0));
H_006(:,3)=min(Results.Hm0);
H_006(:,4)=min(nonzeros(Results.Hm0));
clear Results;

H_all(1,:)=H_001(:,1);
H_all(2,:)=H_001(:,2);
H_all(3,:)=H_001(:,3);
H_all(4,:)=H_001(:,4);

H_all(5,:)=H_002(:,1);
H_all(6,:)=H_002(:,2);
H_all(7,:)=H_002(:,3);
H_all(8,:)=H_002(:,4);

H_all(9,:)=H_003(:,1);
H_all(10,:)=H_003(:,2);
H_all(11,:)=H_003(:,3);
H_all(12,:)=H_003(:,4);

H_all(13,:)=H_004(:,1);
H_all(14,:)=H_004(:,2);
H_all(15,:)=H_004(:,3);
H_all(16,:)=H_004(:,4);

H_all(17,:)=H_005(:,1);
H_all(18,:)=H_005(:,2);
H_all(19,:)=H_005(:,3);
H_all(20,:)=H_005(:,4);

H_all(21,:)=H_006(:,1);
H_all(22,:)=H_006(:,2);
H_all(23,:)=H_006(:,3);
H_all(24,:)=H_006(:,4);


figure_Hm=figure;
figure_Hm.WindowState = 'maximized';

axesHm = axes('Parent',figure_Hm);
hold(axesHm,'on');
scatter(1620,H_all(21,:),'LineWidth',2); 
hold on; 
scatter(1020,H_all(5,:),'LineWidth',2); 
hold on; 
scatter(810,H_all(13,:),'LineWidth',2); 
hold on; 
scatter(330,H_all(1,:),'LineWidth',2); 
hold on; 
scatter(100,H_all(17,:),'LineWidth',2); 
hold on; 
scatter(23, H_all(9,:),'LineWidth',2); 
hold on;
%max
x_plot=[1620 1020 810 330 100 23].';
y_plot=[H_all(21,:) H_all(5,:) H_all(13,:) H_all(1,:) H_all(17,:) H_all(9,:)].';
line(x_plot, y_plot,'LineWidth',1,'LineStyle','--');
hold on;
%mean
x_plot=[1620 1020 810 330 100 23].';
y_plot=[H_all(22,:) H_all(6,:) H_all(14,:) H_all(2,:) H_all(18,:) H_all(10,:)].';
line(x_plot, y_plot,'LineWidth',3);
hold on;
%min
x_plot=[1620 1020 810 330 100 23].';
y_plot=[H_all(23,:) H_all(7,:) H_all(15,:) H_all(3,:) H_all(19,:) H_all(11,:)].';
line(x_plot, y_plot,'LineWidth',1,'LineStyle','--');
hold on;
%min_non zero
x_plot=[1620 1020 810 330 100 23].';
y_plot=[H_all(24,:) H_all(8,:) H_all(16,:) H_all(4,:) H_all(20,:) H_all(12,:)].';
line(x_plot, y_plot,'LineWidth',1,'LineStyle','--');


%title(' Cross-shore Variation');
xlabel('Cross-shore Distance [m]','FontWeight','bold','FontAngle','italic');
ylabel('H_s [m]','FontWeight','bold','FontAngle','italic');
box(axesHm,'on');
set(axesHm,'FontAngle','italic','FontSize',24,'XDir','reverse','XGrid','on','XMinorTick','on',...
'YGrid','on');
legend('MB 8','MB 7','MB 6','MB 4','MB 2','MB 1')

Path_figures= 'F:\Wave_processing\Final\OSSI_Deployment_5\Figures_final\';

savefig(gcf, [Path_figures,'All,  Sig. Wave Heights v3' '.fig'], 'compact')
saveas(gcf,  [Path_figures,'All  Sig. Wave Heights v3' '.png'])

delete(figure_Hm)
%%
%Period
clear all
% Comparison of Wave Heights
load('WaveParameters_001.mat');
Tm0=Results.Tm0;
H_001(:,1)=max(Results.Tm0);
H_001(:,2)=mean(Results.Tm0);
H_001(:,3)=min(Results.Tm0);
clear Results;


load('WaveParameters_002.mat');
hm0_2=Results.Tm0;
H_002(:,1)=max(Results.Tm0);
H_002(:,2)=mean(Results.Tm0);
H_002(:,3)=min(Results.Tm0);
clear Results;

load('WaveParameters_003.mat');
hm0_3=Results.Tm0;
H_003(:,1)=max(Results.Tm0);
H_003(:,2)=mean(Results.Tm0);
H_003(:,3)=min(Results.Tm0);
clear Results;

load('WaveParameters_004.mat');
hm0_4=Results.Tm0;
H_004(:,1)=max(Results.Tm0);
H_004(:,2)=mean(Results.Tm0);
H_004(:,3)=min(Results.Tm0);

clear Results;

load('WaveParameters_005.mat');
hm0_5=Results.Tm0;
H_005(:,1)=max(Results.Tm0);
H_005(:,2)=mean(Results.Tm0);
H_005(:,3)=min(Results.Tm0);

clear Results;

load('WaveParameters_006.mat');
hm0_6=Results.Tm0;
H_006(:,1)=max(Results.Tm0);
H_006(:,2)=mean(Results.Tm0);
H_006(:,3)=min(Results.Tm0);
clear Results;

H_all(1,:)=H_001(:,1);
H_all(2,:)=H_001(:,2);
H_all(3,:)=H_001(:,3);
H_all(4,:)=H_002(:,1);
H_all(6,:)=H_002(:,2);
H_all(7,:)=H_002(:,3);
H_all(8,:)=H_003(:,1);
H_all(9,:)=H_003(:,2);
H_all(10,:)=H_003(:,3);
H_all(11,:)=H_004(:,1);
H_all(12,:)=H_004(:,2);
H_all(13,:)=H_004(:,3);
H_all(14,:)=H_005(:,1);
H_all(15,:)=H_005(:,2);
H_all(16,:)=H_005(:,3);
H_all(17,:)=H_006(:,1);
H_all(18,:)=H_006(:,2);
H_all(19,:)=H_006(:,3);


figure_Hm=figure;
figure_Hm.WindowState = 'maximized';

axesHm = axes('Parent',figure_Hm);
hold(axesHm,'on');
scatter(1620,H_all(17,:),'LineWidth',2); 
hold on; 
scatter(1020,H_all(4,:),'LineWidth',2); 
hold on; 
scatter(810,H_all(11,:),'LineWidth',2); 
hold on; 
scatter(330,H_all(1,:),'LineWidth',2); 
hold on; 
scatter(100,H_all(14,:),'LineWidth',2); 
hold on; 
scatter(23, H_all(8,:),'LineWidth',2); 
hold on;
%max
x_plot=[1620 1020 810 330 100 23].';
y_plot=[H_all(17,:) H_all(4,:) H_all(11,:) H_all(1,:) H_all(14,:) H_all(8,:)].';
line(x_plot, y_plot,'LineWidth',1,'LineStyle','--');
hold on;
%mean
x_plot=[1620 1020 810 330 100 23].';
y_plot=[H_all(18,:) H_all(6,:) H_all(12,:) H_all(2,:) H_all(15,:) H_all(9,:)].';
line(x_plot, y_plot,'LineWidth',3);
hold on;
%min
x_plot=[1620 1020 810 330 100 23].';
y_plot=[H_all(19,:) H_all(7,:) H_all(13,:) H_all(3,:) H_all(16,:) H_all(10,:)].';
line(x_plot, y_plot,'LineWidth',1,'LineStyle','--');


%title(' Cross-shore Variation');
xlabel('Cross-shore Distance [m]','FontWeight','bold','FontAngle','italic');
ylabel('T_m [s]','FontWeight','bold','FontAngle','italic');
box(axesHm,'on');
set(axesHm,'FontAngle','italic','FontSize',24,'XDir','reverse','XGrid','on','XMinorTick','on',...
'YGrid','on');
legend('MB 8','MB 7','MB 6','MB 4','MB 2','MB 1')

Path_figures= 'F:\Wave_processing\Final\OSSI_Deployment_5\Figures_final\';

savefig(gcf, [Path_figures,'All,Peak Periods' '.fig'], 'compact')
saveas(gcf,  [Path_figures,'All Peak Periods' '.png'])

delete(figure_Hm)

%% Depths
clear all
% Comparison of Wave Heights
load('WaveParameters_001.mat');
Tm0=Results.Depth;
H_001(:,1)=max(Results.Depth(1,:));
H_001(:,2)=mean(Results.Depth(1,:));
H_001(:,3)=min(Results.Depth(1,:));
clear Results;


load('WaveParameters_002.mat');
hm0_2=Results.Depth;
H_002(:,1)=max(Results.Depth(1,:));
H_002(:,2)=mean(Results.Depth(1,:));
H_002(:,3)=min(Results.Depth(1,:));
clear Results;

load('WaveParameters_003.mat');
hm0_3=Results.Depth;
H_003(:,1)=max(Results.Depth(1,:));
H_003(:,2)=mean(Results.Depth(1,:));
H_003(:,3)=min(Results.Depth(1,:));
clear Results;

load('WaveParameters_004.mat');
hm0_4=Results.Depth;
H_004(:,1)=max(Results.Depth(1,:));
H_004(:,2)=mean(Results.Depth(1,:));
H_004(:,3)=min(Results.Depth(1,:));

clear Results;

load('WaveParameters_005.mat');
hm0_5=Results.Depth;
H_005(:,1)=max(Results.Depth(1,:));
H_005(:,2)=mean(Results.Depth(1,:));
H_005(:,3)=min(Results.Depth(1,:));

clear Results;

load('WaveParameters_006.mat');
hm0_6=Results.Depth;
H_006(:,1)=max(Results.Depth(1,:));
H_006(:,2)=mean(Results.Depth(1,:));
H_006(:,3)=min(Results.Depth(1,:));
clear Results;

H_all(1,:)=H_001(:,1);
H_all(2,:)=H_001(:,2);
H_all(3,:)=H_001(:,3);
H_all(4,:)=H_002(:,1);
H_all(6,:)=H_002(:,2);
H_all(7,:)=H_002(:,3);
H_all(8,:)=H_003(:,1);
H_all(9,:)=H_003(:,2);
H_all(10,:)=H_003(:,3);
H_all(11,:)=H_004(:,1);
H_all(12,:)=H_004(:,2);
H_all(13,:)=H_004(:,3);
H_all(14,:)=H_005(:,1);
H_all(15,:)=H_005(:,2);
H_all(16,:)=H_005(:,3);
H_all(17,:)=H_006(:,1);
H_all(18,:)=H_006(:,2);
H_all(19,:)=H_006(:,3);


figure_Hm=figure;
figure_Hm.WindowState = 'maximized';

axesHm = axes('Parent',figure_Hm);
hold(axesHm,'on');
scatter(1620,H_all(17,:),'LineWidth',2); 
hold on; 
scatter(1020,H_all(4,:),'LineWidth',2); 
hold on; 
scatter(810,H_all(11,:),'LineWidth',2); 
hold on; 
scatter(330,H_all(1,:),'LineWidth',2); 
hold on; 
scatter(100,H_all(14,:),'LineWidth',2); 
hold on; 
scatter(23, H_all(8,:),'LineWidth',2); 
hold on;
%max
x_plot=[1620 1020 810 330 100 23].';
y_plot=[H_all(17,:) H_all(4,:) H_all(11,:) H_all(1,:) H_all(14,:) H_all(8,:)].';
line(x_plot, y_plot,'LineWidth',1,'LineStyle','--');
hold on;
%mean
x_plot=[1620 1020 810 330 100 23].';
y_plot=[H_all(18,:) H_all(6,:) H_all(12,:) H_all(2,:) H_all(15,:) H_all(9,:)].';
line(x_plot, y_plot,'LineWidth',3);
hold on;
%min
x_plot=[1620 1020 810 330 100 23].';
y_plot=[H_all(19,:) H_all(7,:) H_all(13,:) H_all(3,:) H_all(16,:) H_all(10,:)].';
line(x_plot, y_plot,'LineWidth',1,'LineStyle','--');

%title(' Cross-shore Variation');
xlabel('Cross-shore Distance [m]','FontWeight','bold','FontAngle','italic');
ylabel('Depth [m]','FontWeight','bold','FontAngle','italic');
box(axesHm,'on');
set(axesHm,'FontAngle','italic','FontSize',24,'XDir','reverse','XGrid','on','XMinorTick','on',...
'YGrid','on');
legend('MB 8','MB 7','MB 6','MB 4','MB 2','MB 1')

Path_figures= 'F:\Wave_processing\Final\OSSI_Deployment_5\Figures_final\';

savefig(gcf, [Path_figures,'All Depths' '.fig'], 'compact')
saveas(gcf,  [Path_figures,'All Depths' '.png'])

delete(figure_Hm)

%% Hs/d
clear all
% Comparison of Wave Heights
load('WaveParameters_001.mat');
Hm0_1=Results.Hm0;
Depth_1=(Results.Depth(:,1:276)).';
ratio_1=Hm0_1(:,1)./Depth_1(:,1);

H_001(:,1)=max(ratio_1);
H_001(:,2)=mean(ratio_1);
H_001(:,3)=min(ratio_1);
clear Results;


load('WaveParameters_002.mat');
Hm0_2=Results.Hm0;
Depth_2=(Results.Depth(:,1:280)).';
ratio_2=Hm0_2(:,1)./Depth_2(:,1);

H_002(:,1)=max(ratio_2);
H_002(:,2)=mean(ratio_2);
H_002(:,3)=min(ratio_2);
clear Results;

load('WaveParameters_003.mat');
Hm0_3=Results.Hm0;
Depth_3=(Results.Depth(:,1:280)).';
ratio_3=Hm0_3(:,1)./Depth_3(:,1);

H_003(:,1)=max(ratio_3);
H_003(:,2)=mean(ratio_3);
H_003(:,3)=min(ratio_3);
clear Results;

load('WaveParameters_004.mat');
Hm0_4=Results.Hm0;
Depth_4=(Results.Depth(:,1:280)).';
ratio_4=Hm0_4(:,1)./Depth_4(:,1);

H_004(:,1)=max(ratio_4);
H_004(:,2)=mean(ratio_4);
H_004(:,3)=min(ratio_4);

clear Results;

load('WaveParameters_005.mat');
Hm0_5=Results.Hm0;
Depth_5=(Results.Depth(:,1:280)).';
ratio_5=Hm0_5(:,1)./Depth_5(:,1);

H_005(:,1)=max(ratio_5);
H_005(:,2)=mean(ratio_5);
H_005(:,3)=min(ratio_5);

clear Results;

load('WaveParameters_006.mat');
Hm0_6=Results.Hm0;
Depth_6=(Results.Depth(:,1:282)).';
ratio_6=Hm0_6(:,1)./Depth_6(:,1);

H_006(:,1)=max(ratio_6);
H_006(:,2)=mean(ratio_6);
H_006(:,3)=min(ratio_6);
clear Results;

H_all(1,:)=H_001(:,1);
H_all(2,:)=H_001(:,2);
H_all(3,:)=H_001(:,3);
H_all(4,:)=H_002(:,1);
H_all(6,:)=H_002(:,2);
H_all(7,:)=H_002(:,3);
H_all(8,:)=H_003(:,1);
H_all(9,:)=H_003(:,2);
H_all(10,:)=H_003(:,3);
H_all(11,:)=H_004(:,1);
H_all(12,:)=H_004(:,2);
H_all(13,:)=H_004(:,3);
H_all(14,:)=H_005(:,1);
H_all(15,:)=H_005(:,2);
H_all(16,:)=H_005(:,3);
H_all(17,:)=H_006(:,1);
H_all(18,:)=H_006(:,2);
H_all(19,:)=H_006(:,3);


figure_Hm=figure;
figure_Hm.WindowState = 'maximized';

axesHm = axes('Parent',figure_Hm);
hold(axesHm,'on');
scatter(1620,H_all(17,:),'LineWidth',2); 
hold on; 
scatter(1020,H_all(4,:),'LineWidth',2); 
hold on; 
scatter(810,H_all(11,:),'LineWidth',2); 
hold on; 
scatter(330,H_all(1,:),'LineWidth',2); 
hold on; 
scatter(100,H_all(14,:),'LineWidth',2); 
hold on; 
scatter(23, H_all(8,:),'LineWidth',2); 
hold on;
%max
x_plot=[1620 1020 810 330 100 23].';
y_plot=[H_all(17,:) H_all(4,:) H_all(11,:) H_all(1,:) H_all(14,:) H_all(8,:)].';
line(x_plot, y_plot,'LineWidth',1,'LineStyle','--');
hold on;
%mean
x_plot=[1620 1020 810 330 100 23].';
y_plot=[H_all(18,:) H_all(6,:) H_all(12,:) H_all(2,:) H_all(15,:) H_all(9,:)].';
line(x_plot, y_plot,'LineWidth',3);
hold on;
%min
x_plot=[1620 1020 810 330 100 23].';
y_plot=[H_all(19,:) H_all(7,:) H_all(13,:) H_all(3,:) H_all(16,:) H_all(10,:)].';
line(x_plot, y_plot,'LineWidth',1,'LineStyle','--');

%title(' Cross-shore Variation');
xlabel('Cross-shore Distance [m]','FontWeight','bold','FontAngle','italic');
ylabel('H_s / Depth [-]','FontWeight','bold','FontAngle','italic');
box(axesHm,'on');
set(axesHm,'FontAngle','italic','FontSize',24,'XDir','reverse','XGrid','on','XMinorTick','on',...
'YGrid','on');
legend('MB 8','MB 7','MB 6','MB 4','MB 2','MB 1')

Path_figures= 'F:\Wave_processing\Final\OSSI_Deployment_5\Figures_final\';

savefig(gcf, [Path_figures,'All ratios' '.fig'], 'compact')
saveas(gcf,  [Path_figures,'All ratios' '.png'])

delete(figure_Hm)

%%
    
% Comparison of the Variance Density Spectrum
load('WaveParameters_001.mat');
f_1=Results.f;
v_1=Results.v;
clear Results;

load('WaveParameters_002.mat');
f_2=Results.f;
v_2=Results.v;
clear Results;


load('WaveParameters_003.mat');
f_3=Results.f;
v_3=Results.v;
clear Results;


load('WaveParameters_004.mat');
f_4=Results.f;
v_4=Results.v;
clear Results;


load('WaveParameters_005.mat');
f_5=Results.f;
v_5=Results.v;
clear Results;


load('WaveParameters_006.mat');
f_6=Results.f;
v_6=Results.v;
clear Results;


figure_v=figure;
figure_v.WindowState = 'maximized';

axesv = axes('Parent',figure_v);
hold(axesv,'on');
semilogx(f_1,v_1,'LineWidth',2);
hold on;
semilogx(f_2,v_2,'LineWidth',2);
hold on;
semilogx(f_3,v_3,'LineWidth',2);
hold on;
semilogx(f_4,v_4,'LineWidth',2);
hold on;
semilogx(f_5,v_5,'LineWidth',2);
hold on;
semilogx(f_6,v_6,'LineWidth',2);

title('Variance Density per Burst ');
xlabel('Frequency (Hz)');
ylabel('Energy Density (m^2. s');
box(axesv,'on');
set(axesv,'FontSize',20,'XGrid','on','XMinorTick','on','XScale','log',...
'YGrid','on');
legend('OSSI_001','OSSI_002','OSSI_003','OSSI_004','OSSI_005','OSSI_006')

savefig(gcf, [Path_figures,'All, Variance Density' '.fig'], 'compact')
saveas(gcf,  [Path_figures,'All, Variance Density' '.png'])

delete(figure_v)

%%
    
% Comparison of the Energy Density Spectrum
load('WaveParameters_001.mat');
E_1=Results.E;
v_1=Results.v;

load('WaveParameters_002.mat');
E_2=Results.E;
v_2=Results.v;


load('WaveParameters_003.mat');
E_3=Results.E;
v_3=Results.v;


load('WaveParameters_004.mat');
E_4=Results.E;
v_4=Results.v;


load('WaveParameters_005.mat');
E_5=Results.E;
v_5=Results.v;


load('WaveParameters_006.mat');
E_6=Results.E;
v_6=Results.v;


figure_E=figure;
figure_E.WindowState = 'maximized';

axesE = axes('Parent',figure_E);
hold(axesE,'on');
semilogx(f_1,E_1,'LineWidth',2);
hold on;
semilogx(f_2,E_2,'LineWidth',2);
hold on;
semilogx(f_3,E_3,'LineWidth',2);
hold on;
semilogx(f_4,E_4,'LineWidth',2);
hold on;
semilogx(f_5,E_5,'LineWidth',2);
hold on;
semilogx(f_6,E_6,'LineWidth',2);

title('Energy Density per Burst ');
xlabel('Frequency (Hz) / wave number (-)');
ylabel('Energy Density, m^(2).s');
box(axesE,'on');
set(axesE,'FontSize',20,'XGrid','on','XMinorTick','on','XScale','log',...
'YGrid','on');
legend('OSSI_001','OSSI_002','OSSI_003','OSSI_004','OSSI_005','OSSI_006')

savefig(gcf, [Path_figures,'All,Energy Density' '.fig'], 'compact')
saveas(gcf,  [Path_figures,'All,Energy Density' '.png'])

delete(figure_E)
%%

function [k]=wavenumber(T,h)
eps = 1*10^(-5);
omeg=2*pi()/T;
ko=(omeg^2)/9.81;
x=ko*h;
diff=1;
if x>2*pi()
    k=ko;
else
    while (diff>eps)
    f=ko*h-x*tanh(x);
    df=tanh(x)+x*cosh(x)/cosh(x);
    dx=f/df;
    xc=x+dx;
    diff=abs(xc-x);
    x=xc;
    end
    k=x/h;
end
end
